using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Web;
using System.Web.Services;
using System.Data.SqlClient;


namespace BiblioServices {
    public class BiblioServiceException : System.Exception {
        public BiblioServiceException(string sMessage):base(sMessage) {
        }
    }


    /// <summary>
    /// Summary description for Service1.
    /// </summary>
    [WebService(Namespace="http://betav.com/webservices/")]
    public class BiblioServiceClass : System.Web.Services.WebService {
        private BiblioServiceException bseNoRows = new BiblioServiceException("No Rows resulted from query");
        public BiblioServiceClass() {
            //CODEGEN: This call is required by the ASP.NET Web Services Designer
            InitializeComponent();
        }

#region Component Designer generated code

        //Required by the Web Services Designer 
        private IContainer components = null;

        /// <summary>
        /// Required method for Designer support - do not modify
        /// the contents of this method with the code editor.
        /// </summary>
        private void InitializeComponent() {
        }

        /// <summary>
        /// Clean up any resources being used.
        /// </summary>
        protected override void Dispose( bool disposing ) {
            if(disposing && components != null) {
                components.Dispose();
            }
            base.Dispose(disposing);		
        }

#endregion

        [WebMethod]
        public DataSet AuthorByISBN(string sISBN) {
            DataSet ds;
            try{ 
                ds = new DataSet();
                SqlConnection cn = new SqlConnection("data source=.;database=biblio;uid=admin;pwd=pw");
                SqlCommand cmd = new SqlCommand("AuthorsByISBN",cn);
                SqlDataAdapter da = new SqlDataAdapter(cmd);
                if (sISBN == "" | sISBN ==null) {
                    sISBN = "1-5561590-6-4";
                }
                cmd.CommandType = CommandType.StoredProcedure;
                cmd.Parameters.Add("@ISBNWanted", SqlDbType.VarChar);
                cmd.Parameters["@ISBNWanted"].Value =  sISBN;
                da.Fill(ds);

                if (ds.Tables[0].Rows.Count == 0) {
                    throw bseNoRows;
                }  
                return ds;
            }

            catch(Exception exg) {

                Debug.WriteLine(exg.ToString());
                throw exg;
            }   
        }
        [WebMethod]
        public DataSet TitlesByAuthor(string sAuthorWanted) {
            DataSet ds;
            try {
                ds = new DataSet();

                SqlConnection cn = new SqlConnection("data source=.;database=biblio;uid=admin;pwd=pw");
                SqlCommand cmd = new SqlCommand("TitlesByAuthor", cn);
                SqlDataAdapter da = new SqlDataAdapter(cmd);
                cmd.CommandType = CommandType.StoredProcedure;
                cmd.Parameters.Add("@AuthorWanted", SqlDbType.VarChar);
                cmd.Parameters["@AuthorWanted"].Value = sAuthorWanted;
                da.Fill(ds);
                if (ds.Tables[0].Rows.Count == 0) {
                    throw bseNoRows;
                    }
                return ds;
            }
            catch (Exception exg) {
                Debug.WriteLine(exg.Message);
                throw exg;
            }
        }
    }
}
